<?php
// SHOW ERRORS
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'pdo_config.php';

$keyMessage = '';

if (isset($_POST['check'])) {
    $school_code = trim($_POST['school_code']);

    $stmt = $pdo->prepare("SELECT license_key, valid_until, is_active FROM license_keys WHERE school_code = ? ORDER BY id DESC LIMIT 1");
    $stmt->execute([$school_code]);

    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $keyMessage = "<strong>License Key:</strong> <code>{$row['license_key']}</code><br>";
        $keyMessage .= "<strong>Status:</strong> " . ($row['is_active'] ? '✅ Active' : '❌ Inactive') . "<br>";
        $keyMessage .= "<strong>Valid Until:</strong> {$row['valid_until']}";
    } else {
        $keyMessage = "❌ No license key found for that school code.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Forgot License Key</title>
    <style>
        body { font-family: Arial; background: #f0f0f0; padding: 40px; text-align: center; }
        form {
            background: #fff;
            display: inline-block;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
        }
        input, button {
            padding: 10px;
            width: 300px;
            margin: 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            background-color: #007bff;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
        .message {
            margin-top: 20px;
            padding: 15px;
            background: #fff;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <h2>🔐 Forgot License Key</h2>

    <form method="POST">
        <input type="text" name="school_code" placeholder="Enter School Code" required><br>
        <button name="check">Check License</button>
    </form>

    <?php if ($keyMessage): ?>
        <div class="message">
            <?= $keyMessage ?>
        </div>
    <?php endif; ?>
</body>
</html>
