<?php  
session_start();

// Redirect to login.php if user is not logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);  
ini_set('display_errors', 0);  
/*
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);*/

require_once 'phpqrcode/qrlib.php';  
require_once 'pdo_config.php'; // includes the PDO connection  

// Set proper content header  
header('Content-Type: text/html; charset=utf-8');  

if (isset($_POST['generate'])) {  
    $lrn = $_POST['lrn'];  
    $first = $_POST['first'];  
    $middle = $_POST['middle'];  
    $last = $_POST['last'];  
    $grade = $_POST['grade'];  
    $sex = $_POST['sex'];  
    $birthday = $_POST['birthday'];  
    $number = $_POST['number'];  
    $address = $_POST['address'];  
    $mother = $_POST['mother'];  
    $father = $_POST['father'];  

    $name = "$first $middle $last";  
    $grade_display = ($grade === 'Nursery' || $grade === 'Kindergarten') ? $grade : "Grade $grade";  

    $base_url = "http://159.223.47.179/student_checkin/checkin_auto.php";  
    $qr_url = "$base_url?lrn=" . urlencode($lrn) .  
              "&name=" . str_replace(' ', '+', $name) .  
              "&grade=" . urlencode($grade_display) .  
              "&number=" . urlencode($number) .  
              "&address=" . urlencode($address) .  
              "&mother=" . urlencode($mother) .  
              "&father=" . urlencode($father);  

    $filename = "qr_codes/qr_" . $lrn . ".png";  
    $temp_qr = "qr_codes/temp_qr_" . $lrn . ".png";  
    $logo = "school_logo.png";  

    if (!file_exists("qr_codes")) {  
        mkdir("qr_codes", 0777, true);  
    }  

    QRcode::png($qr_url, $temp_qr, QR_ECLEVEL_H, 6);  
    $QR = imagecreatefrompng($temp_qr);  
    $logo_img = imagecreatefrompng($logo);  

    $qr_width = imagesx($QR);  
    $qr_height = imagesy($QR);  
    $logo_width = imagesx($logo_img);  
    $logo_height = imagesy($logo_img);  

    $logo_qr_width = $qr_width / 4;  
    $scale = $logo_width / $logo_qr_width;  
    $logo_qr_height = $logo_height / $scale;  
    $from_width = ($qr_width - $logo_qr_width) / 2;  

    imagecopyresampled($QR, $logo_img, $from_width, $from_width, 0, 0,  
        $logo_qr_width, $logo_qr_height, $logo_width, $logo_height);  

    imagepng($QR, $filename);  
    unlink($temp_qr);  

    $stmt = $pdo->prepare("INSERT INTO students (lrn, first_name, middle_name, last_name, grade, sex, birthday, contact, address, mother, father)   
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)   
        ON DUPLICATE KEY UPDATE first_name=VALUES(first_name),middle_name=VALUES(middle_name),last_name=VALUES(last_name), grade=VALUES(grade), sex=VALUES(sex), birthday=VALUES(birthday), contact=VALUES(contact), address=VALUES(address), mother=VALUES(mother), father=VALUES(father)");  

    $stmt->execute([$lrn, $first, $middle, $last, $grade, $sex, $birthday, $number, $address, $mother, $father]);  
}  
?>  

<!DOCTYPE html>  
<html lang="en">  
<head>  
    <meta charset="UTF-8">  
    <title>Generate QR | SDAES</title>  
    <style>  
        * { box-sizing: border-box; }  
        body {  
            font-family: Arial, sans-serif;  
            background-color: #121212;  
            color: #fff;  
            padding: 20px;  
            text-align: center;  
        }  
        .container {  
            max-width: 400px;  
            margin: auto;  
        }  
        .school-logo {  
            width: 100px;  
            margin-bottom: 10px;  
        }  
        .school-name {  
            font-size: 16px;  
            font-weight: bold;  
            margin-bottom: 20px;  
        }  
        .card {  
            background-color: #1e1e1e;  
            padding: 25px;  
            border-radius: 15px;  
            box-shadow: 0 0 10px #000;  
        }  
        input, select {  
            padding: 10px;  
            width: 100%;  
            margin: 7px 0;  
            border-radius: 5px;  
            border: 1px solid #ccc;  
            font-size: 14px;  
        }  
        button {  
            padding: 10px;  
            width: 100%;  
            background: #007bff;  
            border: none;  
            border-radius: 5px;  
            color: white;  
            margin-top: 10px;  
            cursor: pointer;
        }  
        button:hover {  
            background: #0056b3;  
        }  
        .qr-container {  
            margin-top: 20px;  
        }  
        .qr-container img {
            max-width: 100%;  
        }  
        .download-link {  
            display: inline-block;  
            margin-top: 10px;  
            color: #00c0ff;  
        }  
        .back-link {  
            display: block;  
            margin-top: 20px;  
            color: #aaa;  
            text-decoration: none;  
        }  
        .back-link:hover {  
            color: #fff;  
        }  
        .dashboard-btn {
            display: inline-block;
            margin-top: 25px;
            padding: 10px 25px;
            background: #28a745;
            color: #fff;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            border: none;
            font-size: 15px;
            cursor: pointer;
        }
        .dashboard-btn:hover {
            background: #218838;
        }
    </style>  
</head>  
<body>  
<div class="container">  
    <img src="school_logo.png" class="school-logo" alt="School Logo">  
    <div class="school-name">SIOCON DISTRICT ADVENTIST ELEMENTARY SCHOOL INC</div>

    <div class="card">  
        <h3>📘 Generate Student QR Code</h3>  
        <form method="POST" accept-charset="UTF-8">  
            <input type="text" name="lrn" placeholder="Student LRN" required>  
            <input type="text" name="first" placeholder="First Name" required>  
            <input type="text" name="middle" placeholder="Middle Name" required>  
            <input type="text" name="last" placeholder="Last Name" required>  

            <select name="grade" required>  
                <option value="" disabled selected hidden>-- Select Grade --</option>  
                <option value="Nursery">Nursery</option>  
                <option value="Kindergarten">Kindergarten</option>  
                <option value="1">Grade 1</option>  
                <option value="2">Grade 2</option>  
                <option value="3">Grade 3</option>  
                <option value="4">Grade 4</option>  
                <option value="5">Grade 5</option>  
                <option value="6">Grade 6</option>  
            </select>  

            <select name="sex" required>  
                <option value="" disabled selected hidden>-- Select Sex --</option>  
                <option value="Male">Male</option>  
                <option value="Female">Female</option>  
            </select>  

            <input type="date" name="birthday" required>  
            <input type="text" name="number" placeholder="Contact Number" required>  
            <input type="text" name="address" placeholder="Address" required>  
            <input type="text" name="mother" placeholder="Mother's Name" required>  
            <input type="text" name="father" placeholder="Father's Name" required>  

            <button type="submit" name="generate">Generate QR Code</button>  
        </form>  

        <?php if (isset($filename) && file_exists($filename)): ?>  
            <div class="qr-container">  
                <img src="<?php echo $filename; ?>" alt="QR Code">  
                <a class="download-link" href="<?php echo $filename; ?>" download>⬇ Download QR Code</a>  
            </div>  
        <?php endif; ?>  
    </div>

    <!-- BACK TO DASHBOARD BUTTON -->
    <a href="dashboard.php" class="dashboard-btn">← Back to Dashboard</a>

</div>  
</body>  
</html>  
