<?php
session_start();
require_once 'pdo_config.php'; // Sigurado nga naa ni

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $lrn = $_POST['lrn'] ?? '';
    $fname = $_POST['first_name'] ?? '';
    $mname = $_POST['middle_name'] ?? '';
    $lname = $_POST['last_name'] ?? '';
    $grade = $_POST['grade'] ?? '';
    $contact = $_POST['contact'] ?? '';
    $sex = $_POST['sex'] ?? '';
    $bday = $_POST['birthday'] ?? '';

    try {
        $stmt = $pdo->prepare("INSERT INTO students (lrn, first_name, middle_name, last_name, grade, contact, sex, birthday) 
                               VALUES (:lrn, :fname, :mname, :lname, :grade, :contact, :sex, :bday)");
        $stmt->execute([
            'lrn' => $lrn,
            'fname' => $fname,
            'mname' => $mname,
            'lname' => $lname,
            'grade' => $grade,
            'contact' => $contact,
            'sex' => $sex,
            'bday' => $bday
        ]);

        $message = "✅ Student <strong>" . strtoupper($lname . ', ' . $fname . ' ' . $mname) . "</strong> added successfully!";
        // Clear form values after success
        $_POST = [];
    } catch (PDOException $e) {
        $message = "❌ Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Student</title>
    <style>
        body {
            background: #121212;
            color: white;
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 30px;
        }
        form {
            background: #1e1e1e;
            display: inline-block;
            padding: 25px 30px;
            border-radius: 10px;
            max-width: 320px;
            width: 100%;
            box-sizing: border-box;
        }
        input, select {
            display: block;
            width: 100%;
            margin: 10px 0;
            padding: 8px;
            border: none;
            border-radius: 5px;
            font-size: 14px;
            box-sizing: border-box;
        }
        button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 5px;
            cursor: pointer;
            width: 100%;
            font-size: 15px;
        }
        button:hover {
            background-color: #0069d9;
        }
        .message {
            margin-bottom: 15px;
            color: lightgreen;
        }
    </style>
</head>
<body>

<?php if (!empty($message)): ?>
    <div class="message"><?= $message ?></div>
<?php endif; ?>

<h2>📋 Add Student to Database</h2>

<form method="POST" action="">
    <input type="text" name="lrn" placeholder="LRN" required>
    <input type="text" name="first_name" placeholder="First Name" required>
    <input type="text" name="middle_name" placeholder="Middle Name" required>
    <input type="text" name="last_name" placeholder="Last Name" required>

    <select name="grade" required>
        <option value="">-- Select Grade --</option>
        <option value="Nursery">Nursery</option>
        <option value="Kindergarten">Kindergarten</option>
        <?php for ($g = 1; $g <= 6; $g++): ?>
            <option value="Grade <?= $g ?>">Grade <?= $g ?></option>
        <?php endfor; ?>
    </select>

    <input type="text" name="contact" placeholder="Contact No." required>

    <select name="sex" required>
        <option value="">-- Select Sex --</option>
        <option value="Male">Male</option>
        <option value="Female">Female</option>
    </select>

    <input type="date" name="birthday" placeholder="Birthday" required>

    <button type="submit">➕ Add Student</button>
</form>

</body>
</html>
